var speed : float = 1.0;
private var prevX : float[];
private var prevY : float[];
private var frame : int = 0;
private var prevMovementScript : Movement_Previous;
private var prevObject : GameObject;
private var started : boolean = false;

function Start(){
	// Exchange "Previous" with the tag of the previous object
	prevObject = GameObject.FindGameObjectWithTag("Previous");
	prevMovementScript = prevObject.GetComponent(Movement_Previous);
	// Replace 50 with the number of frames to be saved, throughout the script
	prevX = new float[50];
	prevY = new float[50];
	for(var i : int = 0; i < 50; i++){
		prevX[i] = 0;
		prevY[i] = 0;
	}
}

function Update () {
    // Get the horizontal and vertical axis.
    // By default they are mapped to the arrow keys.
    // The value is in the range -1 to 1
    var x_translation : float = Input.GetAxis ("Horizontal") * speed;
    var y_translation : float = Input.GetAxis ("Vertical") * speed;
    
    x_translation *= Time.deltaTime;
    y_translation *= Time.deltaTime;
    
    prevX[frame] = x_translation;
    prevY[frame] = y_translation;
    
    // Move translation along the object's x-axis
    transform.Translate (x_translation, y_translation, 0);
   
    frame++;
    if(frame > 49){
    	frame = 0;
    	if(started == false){
    		started = true;
    		prevMovementScript.init();
    	}
    }
}

function getPrevX(i : int) : float{
	return prevX[i];
}

function getPrevY(i : int) : float{
	return prevY[i];
}